-- Make a gradient of given amplitude, levels and center
local function make_gradient(amplitude, levels, center)
    local delta = amplitude/(levels-1)
    local start = center - amplitude/2
    
    local gradient = {} 
    for i = 1, levels, 1 do
        gradient[i] = start + (i-1)*delta
    end
    return gradient
end

-- Duplicates a vector n times as columns of a 2d matrix
local function rep_cols(values, nCols)
    local matrix = {}
    for i = 1, #values, 1 do
        matrix[i] = rep(values[i], nCols)
    end
    return matrix
end

-- Duplicates a vector n times as lines of a 2d matrix
local function rep_lines(values, nLines)
    local matrix = {}
    for i = 1, nLines, 1 do
        matrix[i] = copy_itable(values)
    end
    return matrix
end

-- Makes latitudes gradient, centered on zero
-- Latitudes = lines, longitudes = cols
local function make_latitudes(nLats, nLong, ampLatitudes)
    local gradient = make_gradient(ampLatitudes, nLats, 0) -- TODO allow non centered gradients?
    return rep_cols(gradient, nLong)
end

-- Makes longitudes gradient, centered on zero
-- Latitudes = lines, longitudes = cols
local function make_longitudes(nLats, nLong, ampLongitudes)
    local gradient = make_gradient(ampLongitudes, nLong, 0) -- TODO allow non centered gradients?
    return rep_lines(gradient, nLats)
end


--------------------------------------------------------------------------------

local gradient = {}
gradient.make_latitudes = make_latitudes
gradient.make_longitudes = make_longitudes
return gradient

