-- Id of the trait, must be unique, avoid spaces
id = "S2"
-- List of traits for this species
traitsId = {"T1"}

-- Genetic architecture, species level
-- Total number of locus for all traits defined. Must be consistent with ploidy and genomeSize
nLocus = 7
-- Ploidy, 1 or 2
ploidy = { 2 }
-- Size of the genome should equal nLlocus * ploidy
genomeSize = 14
-- Number of allele per locus
nAllpLoci =  { 10 }
 -- Number of alleles initially present in the meta-population for each trait. Cannot exceed nAllpLoci
nAllInit = { 6 }
--  Crossing rate, >= 0 and <= 0.5
crossingRate = { 0.5 }
-- Positions of chromosom separators
-- ({0, 4, 6} means that loci 0 to 3 are on the same chromosom, then there is a new chromosom at locus 4, and at locus 6
-- (each chromosom is independant from the previous one:
-- a strand of the chromosom is randomly picked at each begin of chromosom)
chromoSplit = {0, 20 }
-- Mutation rate
mutationRate = { 0 }--1e-05 }
-- Inheritance, sum must equal ploidy
inheritance = {
            female = { 1 },
            male =   { 1 },
       }

-- Reproduction regime
-- Assortative or random mating: requires a trait id or nil
assortMating = nil
-- Correlation required between the trait values of the parents under assortative mating
rho = 0.8
-- Selfing rate
selfingRate = 0.001

-- Migration
-- Accepted values: steppingStone, island, matrix, pattern
-- matrix and pattern require a data file
fluxSource = { pollen = "island", seed = "island" }
-- ms (seed dispersal) and mp (pollen dispersal) are only used when fluxSource = steppingStone or island
ms = 0.005
mp = 0.05
-- For initial allelic frequencies generation only
Nm = 10.2

-- Demography
-- Carrying capacity = Maximal number of individuals per cell. Single value for all cells.
cap = 20
-- Growth for demography function
growth = 1 --1.1
-- Initial number of individuals per cell
initDemo =
{
    -- If source == "injection": individuals are taken as described in external file ind.txt
    -- If source == "userdata": matrix initDemo.txt directly filled by user
    -- If source == "value": a unique value is assigned to all cells
    -- If source == "param": generation of a variation of demography according to one dimension
    --     vertical = true for profile following map length, false if follows map width
    --     if param, npop has to be a vector of population demography for each line or column of pop
    source = "value",
    npop = 20,
    --vertical = true
}

-- Selection interaction for matricial fitness computation:
-- the value of Ti_Tj (when different from 0) describes the correlation (+ ou -) between traits
selIntInteractions = {T1_T2 = 5}
