#include "cell.h"

// TODO : add pops from start, populations non dynamically allocated
cell::cell(int myLati, int myLongi, int myAbs) :
lati(myLati), longi(myLongi), abs(myAbs)
{


}


cell::~cell()
{
    //dtor
}


void cell::add_population(population * pPop)
{
    if(pPop == NULL) fail("cell::add_population: entry object is NULL");
    /*if(pPop->get_nInd() == 0)
    {
        cout << "add pop not effective since pop empty" << endl;
        //return; //premature exit, nothing to do
    }*/

    species * pSpe = pPop->get_species(); //Get species of pop
    int index = get_loc(pSpe); //Get position of species in pop vector


    if(index == -1) //If does not exists, add
    {
        index_pop.push_back(pPop);
    }
    else if (index_pop[index]->get_nInd() == 0) //If former empty, replace
    {
        cout << "WARNNG" << endl;
        delete index_pop[index];
        index_pop[index] = pPop;
    }
    else //if both exist => Should not happend
    {
        fail("add_population: Population already exists");
    }
}


void cell::add_individual(individual * pInd, species * pSpe)
{
    if(pInd == NULL || pSpe == NULL) fail("cell::add_individual: entry object is NULL");

    int index = get_loc(pSpe);
    index_pop[index]->add_individual(pInd);
    return;
}



population * cell::get_pop(species * pSpe)
{
    if(pSpe == NULL) fail("cell::get_pop: entry object is NULL");

    for (unsigned int i = 0; i < index_pop.size(); i++)
    {
        if( index_pop[i]->get_species() == pSpe )
        {
            return index_pop[i];
        }
    }
    return NULL;
}


pair<int, int> cell::get_position()
{
    return pair<int, int> (lati, longi);
}





int cell::get_loc(species * pSpe)
{
/*
 * Gives the positions of a pop in the storage index given the species pointer
 */
    if(pSpe == NULL) fail("cell::get_loc: entry object is NULL");

    for (size_t i = 0; i < index_pop.size(); i++)
    {
        if( index_pop[i]->get_species() == pSpe )
        {
            return (int)i;
        }
    }
    return -1;
}

