

local function check_seeds(seed1, seed2, seed1init, seed2init)
    assert_type(seed1, 'integer', "Cfg: Seed 1 Wrong type")
    assert_type(seed2, 'integer', "Cfg: Seed 2 Wrong type")
    assert_type(seed1init, 'integer', "Cfg: Seed 1 init Wrong type")
    assert_type(seed2init, 'integer', "Cfg: Seed 2 init Wrong type")
    return seed1, seed2, seed1init, seed2init
end

local function check_map_dim(mapLength, mapWidth)
    assert_type(mapLength, 'integer', "Cfg: mapLength Wrong type")
    assert_type(mapWidth, 'integer', "Cfg: mapWidth Wrong type")
    assert(mapLength > 0, "Cfg: mapLength Wrong size")
    assert(mapWidth > 0, "Cfg: mapWidth Wrong size")
    return mapLength, mapWidth
end

local function check_simLength(simLength)
    assert_type(simLength, 'integer', "Cfg: simLength Wrong type")
    assert(simLength > 0, "Cfg: simLength Wrong size")
    return simLength
end

local function check_cellRef(cellRef)
    assert_type(cellRef, 'integer', "Cfg: refCell Wrong type")
    assert(cellRef >= 0, "Cfg: refCell Wrong value")
    return cellRef
end

local function check_timeStep(timeStep)
    assert_type(timeStep, 'integer', "Cfg: timeStep Wrong type")
    assert(timeStep > 0, "Cfg: timeStep Wrong size")
    return timeStep
end


local function check_saveStep(saveStep)
    assert_type(saveStep, 'integer', "Cfg: saveStep Wrong type")
    assert(saveStep > 0, "Cfg: saveStep Wrong size")
    return saveStep
end

local function check_isRegression(isRegression)
    assert_type(isRegression, 'boolean', "Cfg: isRegression Wrong type")
    return isRegression
end

local function check_outputDir(outputDir)
    assert_type(outputDir, 'string',  "Cfg: outputDir Wrong type")
    return outputDir
end

-- local function check_paths(pTrait, pSpecies, pOut)
local function check_seedFile(usrSeed)
    local cfg = {}
    -- Seeds
    cfg.seed1, cfg.seed2, cfg.seed1init, cfg.seed2init = check_seeds(usrSeed.seed1, usrSeed.seed2, usrSeed.seed1init, usrSeed.seed2init)
    return cfg
end

local function check(usrCfg)
    local cfg = {}
    -- Map Dimensions
    cfg.mapLength, cfg.mapWidth = check_map_dim(usrCfg.mapLength, usrCfg.mapWidth)
    -- Number of simulation steps
    cfg.simLength = check_simLength(usrCfg.simLength)
    cfg.timeStep = 1--check_timeStep(usrCfg.timeStep)
    cfg.saveStep = check_saveStep(usrCfg.saveStep)
    cfg.isRegression = false --check_isRegression(usrCfg.isRegression)
    -- cellRef used for geneflow analysis: where are the parents of a pop from? [CAUTION: first pop (top left) is 0, 1 is the right neighbor...]
    -- left to right, top to bottom
    cfg.cellRef = check_cellRef(usrCfg.refCell)
    -- Paths
    cfg.outputDir = check_outputDir(usrCfg.outputDir)
    return cfg
end


--------------------------------------------------------------------------------
--------------------------------------------------------------------------------
--------------------------------------------------------------------------------
local module = {}
module.check = check
module.check_seedFile = check_seedFile
return module

