
-- eActiv, eLongActiv must be booleans (not 0/1)
-- E_activated -> if not make an empty matrix
local function make(latitudes, Ke)
    local nLines = #latitudes
    local nCols = #latitudes[1]
    local Es = {}

    nInterv = nLines
    if nCols > nLines then nInterv = nCols end
    local delta = Ke/(nInterv-1)

    for i = 1, nLines do
        if nLines >= nCols then
            coefL = 1
        else
            coefL = 0
        end
        Es[i] = {}
        for j = 1, nCols do
            Es[i][j] = -Ke/2+(i-1)*coefL*delta+(j-1)*(1-coefL)*delta
        end
    end

    return Es
end


-------------------------------     Packing        -----------------------------

local E = {}
E.make = make
return E
