#ifndef MAP_H
#define MAP_H

#include <sstream>
#include <fstream>
#include <map>

#include "cell.h"
#include "mClock.h"
#include "group_index.h"

class individual;
class cell;
class species;
class mClock;
class group_index;

// Redo ALL iteration process using vector iterator !


//A ensemble of cells, mapped on a coordinate system
class landscape
{
    public:
        landscape(int lati, int longi);//, int Eref);
        virtual ~landscape();

        cell * pCell(unsigned int abs_pos);
        unsigned int nCells();

        cell * get_cell(int m_lati, int m_longi);
        cell * get_cell(int m_iter);
        cell * next_cell();
        cell * current_cell();


        unsigned int max_size();
        int max_lati();
        int max_longi();
        int iter_from_coord(int m_lati, int m_longi);
        int longi_from_iter(int m_iter);
        int lati_from_iter(int m_iter);

        int get_iter();
        int iter_next();
        int iter_move(int m_x);
        int iter_set(int m_x);
        int iter_set(int m_longi, int m_lati);
        int iter_set_begin();

        int longi_next();
        int longi_move(int m_x);
        int longi_set(int m_x);
        int longi_set_begin();
        int get_longi();

        int lati_next();
        int lati_move(int m_x);
        int lati_set(int m_x);
        int lati_set_begin();
        int get_lati();

        void addIsEmptyForSpe(species * s);
        void setIsEmpty(species * s, int c, bool isEmpty);
        bool getIsEmpty(species * s, int c);
        vector<bool> isPopEmptyInSpe(species * s);
        vector<int> getPopulatedPops(species * s);
        void refreshIsEmptyForSpe(species * m_pSpe);

        void print_demographics(mClock * myClock, species * m_pSpe);
        void print_index(mClock * m_clock, species * m_pSpe, string key);

    protected:
    private:
        int dim_lati;
        int dim_longi;
        //int Eref;
        std::vector<cell> cellVect;

        // TMP : to avoid emptiness issues : list of empty cells by specie
        map<species *, vector<bool>> isPopEmpty;

        int longi_iter;
        int lati_iter;



};



//Simplified access
inline cell * landscape::pCell(unsigned int abs_pos)
{
    return &cellVect[abs_pos];
}

inline unsigned int landscape::nCells()
{
    return cellVect.size();
}


#endif // MAP_H
