#ifndef LTYPES_H
#define LTYPES_H

#include <iostream>
#include <string>
#include <vector>
#include <valarray>
#include <math.h>




#include "individual.h"


//Simplified a lot on march 27 2015


class ltypes
{
    public:
        ltypes(string myId, vector< vector<double> > myAllEff, vector<unsigned int> myLoci, vector<int> ploidy, int myPow);
        virtual ~ltypes();

        double calc_add_value_one_locus(individual& myInd, double E, unsigned int locus);
        double calc_add_value(individual& myInd, double E);
        double raw_loc_sum_one_locus(individual& myInd, unsigned int locus);
        double raw_loc_sum(individual& myInd);

        unsigned int get_rel_locus_pos(unsigned int abs_pos);

        bool has_locus(unsigned int locus);

        inline double get_AE_safe(unsigned int locus, unsigned int value);
        vector<unsigned int> get_locList() {return locList;};
        string get_id() {return id;};

    protected:
    private:
        // 1 : Name
        string id;
        // 2 : Allelic Effects
        vector< vector<double> > allEff;
        // 3 : List of locus used in this type
        vector<unsigned int> locList;
        // 4 : Locus positions on genome
        vector<vector<unsigned int>> locus_position;
        // 5 : power of E
        int powE;
};

//Debug purpose
inline double ltypes::get_AE_safe(unsigned int locus, unsigned int value)
{
    if(allEff.size() <= locus) cout << "AE : " << allEff.size() << "locus " << locus << endl;
    vector<double>& temp = allEff.at(locus);
    if(temp.size() <= value) cout << "max : " << temp.size() << "value " << value << endl;
    return temp.at(value);
}


#endif // LTYPES_H
