-- Id of the trait, must be unique, avoid spaces
id = "S1"
-- List of traits for this species
traitsId = {"T1"}
-- Genetic architecture, species level
-- Total number of locus for all traits defined. Must be consistent with ploidy and genomeSize
nLocus = 20
-- Ploidy, 1 or 2
ploidy = { 2 }
-- Size of the genome should equal nLlocus * ploidy
genomeSize = 40
-- Number of allele per locus
nAllpLoci =  { 10 }
 -- Number of alleles initially present in the meta-population for each trait. Cannot exceed nAllpLoci
nAllInit = { 6 }
--  Crossing rate, >= 0 and <= 0.5
crossingRate = { 0.5 }
-- Beginning of chromosomes
chromoSplit = {0, 20}
-- Mutation rate
mutationRate = { 0.0001 }
-- Inheritance, sum must equal ploidy
inheritance = {
            female = { 1 },
            male =   { 1 },
       }
-- Reproduction regime
-- Assortative or random mating: requires a trait id or nil
assortMating = nil --"T1"
-- Correlation required between the trait values of the parents under assortative mating
rho = 0.8
-- Selfing rate
selfingRate = 0.02
-- Migration
-- Accepted values: steppingStone, island, matrix, pattern
-- matrix and pattern require a data file
fluxSource = { pollen = "island", seed = "island" }
-- ms (seed dispersal) and mp (pollen dispersal) are only used when fluxSource = steppingStone or island
ms = 0.0002  -- 0.0002 par défaut
mp = 0.02  -- 0.02 pardéfaut
-- For initial allelic frequencies generation only
Nm = 10
-- Demography
-- Carrying capacity = Maximal number of individuals per cell. Single value for all cells.
cap = 500
-- Growth for demography function
growth = 0
-- Initial number of individuals per cell
initDemo =
{
    -- If source == "userdata": matrix demo.txt directly filled by user
    -- If source == "injection": individuals are taken as described in external file ind.txt
    -- If source == "value": a unique value is assigned to all cells
    -- If source == "param": generation of a variation of demography according to one dimension
    --     vertical = true for profile following map length, false if follows map width
    --     if param, npop has to be a vector of population demography for each line or column of pop
    source = "value",
    npop = 500
}
-- Selection interaction for matricial fitness computation:
-- the value of Ti_Tj (when different from 0) describes the correlation (+ ou -) between traits
selIntInteractions = {T1_T2 = 0}
